' *******************************************************
' v1.18 update (loader4)
' 1. load this file to the Micromite using AUTOSAVE
' 2. at the command prompt type "UPDATE" and press return
' 3. follow the onscreen instructions
' *******************************************************

Option break 0
Option baudrate 38400
n=0
Print Chr$(&HC1);
checkOK(n)

Do
  Read a$
  If a$="finished" Then Exit Do
  Read b$, c$
  n=n+1

  For i=1 To Len(a$) Step 2
    Print Chr$(Val("&H"+Mid$(a$,i,2)));
  Next i
  checkOK(n)

  For i=1 To Len(b$) Step 2
    Print Chr$(Val("&H"+Mid$(b$,i,2)));
  Next i

  For i=1 To Len(c$) Step 2
    Print Chr$(Val("&H"+Mid$(c$,i,2)));
  Next i
  checkOK(n)
Loop

Option autorun OFF
Do
  Pause 1000
  Print "update to v1.18 completed, press any key..."
Loop Until Inkey$<>""
End


Sub checkOK(n)
  Timer=0
  Do
  Loop Until Inkey$="K" Or Timer>100
  If Timer>100 Then
    Print "process timed out at step ",n
    End
  EndIf
End Sub


Sub UPDATE
  Print "checking update data...";
  CS%=0

  Do
    Read a$
    If a$="finished" Then Exit Do
    Read b$, c$
    If  Len(a$)<>12 Or Len(b$)<>70 Or Len(c$)<>70 Then
      Print " failed"
      End
    EndIf

    For i=1 To Len(a$) Step 2
      CS%=CS%+Val("&H"+Mid$(a$,i,2))
    Next i

    For i=1 To Len(b$) Step 2
      CS%=CS%+Val("&H"+Mid$(b$,i,2))
    Next i

    For i=1 To Len(c$) Step 2
      CS%=CS%+Val("&H"+Mid$(c$,i,2))
    Next i
  Loop

  if (CS% and &hFFFF)<>0 then
    print " checksum error ", CS% and &hFFFF
    end
  endif

  Print " passed"

  Option autorun on
  Print "autorun has been enabled"
  Print "v1.18 update"
  Print
  Print "Instructions:"
  Print "============="
  Print
  Print "1. power cycle the Micromite and PIC16F1455 together,"
  Print "   i.e. unplug the USB connection, then plug back in."
  Print
  Print "2. the update will run automatically and is completed"
  Print "   when you hear the Windows USB driver loaded sound."
  Print "   (this should take just under 30 seconds)"
  Print
  Print "3. reconnect the terminal session if TeraTerm does not do"
  Print "   so automatically. the new 1455 firmware is now loaded."
  Print
  Print "*********************************************************"
  Print "* unplug the USB connection NOW, plug in again and wait *"
  Print "* 30 seconds for the 1455 firmware upgrade to complete. *"
  Print "*********************************************************"
  Print
  Do: Loop
End Sub




data "0000000101FE"
data "00000002419831002F003008007E1480312000911C0A280B2853282100CE0ACB0A0319"
data "CC0A23005403031D15281628192822000E155028550803191D281E282928D50120007F"
data "0000200101DE"
data "00002002416E08031D242825282928E801E9010130EE0020006E0803192E282F284E28"
data "68086904031D34283528372822000E153230200068066904031D3E283F284128220027"
data "0000400101BE"
data "00004002410E119630200068066904031D482849284A28EE01E80A0319E90A50282200"
data "0E112000911056288B31722380317E10090080315A28AA308400213085004630FE00CE"
data "00006001019E"
data "00006002410230FF009C31E324803164308400003085000C30FE000030FF009C31E324"
data "80312100CB01CC01CD01CE01CF01CB308400013085001430FE000030FF009C31E3244B"
data "00008001017E"
data "0000800241803120308400023085003830FE000030FF009C31E3248031230088313920"
data "8031DF0088313A208031E00088313B208031E10088313C208031E20088313D20803169"
data "0000A001015E"
data "0000A00241E30088313E208031E40088313F208031E50024009D3199258031D8009D31"
data "9A258031D9009D319B258031DA009D319C258031DB009D319D258031DC009D319E25AE"
data "0000C001013E"
data "0000C002418031DD009D319F258031DE009D31A0258031DF009D31A1258031E0009D31"
data "A2258031E1009D31A3258031E2009D31A4258031E3009D31A5258031E4009D31A625C5"
data "0000E001011E"
data "0000E002418031E5009D31A7258031E6009D31A8258031E7009D31A9258031E8009D31"
data "AA258031E9009D31AB258031EA009D31AC258031EB009D31AD258031EC007E10200018"
data "0001000101FD"
data "00010002418131022921302100C900AA30C800C7014908A1004808A000913114218131"
data "9D31C42581319C31D72481319331ED2381312300D401643021004E02031C2029212997"
data "0001200101DD"
data "00012002411A29CE0120006A08031D27292829A7298C192B292C29662921004708031D"
data "312932293729C701C70ACB01CC01A72901304C02903003194B02031C3F2940294329DF"
data "0001400101BD"
data "00014002418E1122008E110F3021004C02A13003194B02031C4C294D29592911304C02"
data "303003194B0203185529562959292300D401D40A113021004C02303003194B02031C48"
data "00016001019D"
data "000160024162296329A7292300D401A72921004703031D6B296C29A72901304C029030"
data "03194B020318742975297629C7010F304C02A03003194B0203187E297F299829C7010B"
data "00018001017D"
data "00018002412300D401D40A2000EA01EA0A21008E1122008E1121008C1222008C122100"
data "0C1222000C1224008C160C1631302100C0000F304C02A03003194B02031CA029A12946"
data "0001A001015D"
data "0001A00241A729C701583094314D248131A7299C3191248131003A0319AE29AF292229"
data "02309D3135258131003A031DB729B829862A02309D3118258131003A0319C029C129D1"
data "0001C001013D"
data "0001C00241862A4808443E86000230493D87004030B8000230B900403F3802BA00413F"
data "393BBB003B08803ABC0080303C02031DDA2941303A02031CDD29DE29862AC13021001B"
data "0001E001011D"
data "0001E00241A30002309E3141268131C400C50144084504031DEC29ED29EE29822ACA01"
data "5F2A4808443E86000230493D8700403FB800413FB9003908803ABA0082303A02031DD4"
data "0002000101FC"
data "0002000241032A403038020318062A072A5D2A21004A08B800B9013808410786003908"
data "423D87000108BA004808403E86000230493D8700403F4807BB00413F493DBC003B08C3"
data "0002200101DC"
data "000220024186003C0887003A0881004808403E86000230493D87000130810741310318"
data "810A4808403E86000230493D8700403FB800413FB9003908803ABA0082303A02031D5D"
data "0002400101BC"
data "0002400241432A40303802031C462A472A512A21004808403E86000230493D87000030"
data "C03FC13F21004808443E86000230493D87000130810741310318810A2100CA0A4A0836"
data "00026001019C"
data "0002600241B800B90145083902031D682A44083802031C6B2A6C2AF029403044064504"
data "031D722A732A822A02309C31EF248131003A031D7B2A7C2A732AA401A5010230923178"
data "00028001017C"
data "000280024186228131023093318F23813120006A0803198B2A8C2A662E8C198F2A902A"
data "A72A21004708031D952A962A9B2AC701C70ACB01CC01BD2A0F304C02A03003194B023E"
data "0002A001015C"
data "0002A00241031CA32AA42ABD2A2300D401BD2A21004703031DAC2AAD2ABD2A0F304C02"
data "A03003194B020318B52AB62AB82AC701BD2AC701583094314D2481312100BF014C2EB8"
data "0002C001013C"
data "0002C00241BF0A4808423E86000230493D8700403F48078400413F493D85000008CA00"
data "4808423E86000230493D87000130810741310318810A4808423E86000230493D8700F3"
data "0002E001011C"
data "0002E00241403FB800413FB9003908803ABA0082303A02031DED2A40303802031CF02A"
data "F12AFB2A21004808423E86000230493D87000030C03FC13F21004808443E86000230DE"
data "0003000101FB"
data "0003000241493D8700FF3081074131FF30813D7F3169304A06031D0D2B0E2B802B8C12"
data "22008C12000022000C16000022000C12000022000C16000022000C1221008C16000099"
data "0003200101DB"
data "000320024122000C16000022000C12000022000C16000022000C1221008C1200002200"
data "0C16000022000C12000022000C16000022000C1221008C16000022000C1600002200A2"
data "0003400101BB"
data "00034002410C12000022000C16000022000C1221008C12000022000C16000022000C12"
data "000022000C16000022000C1221008C16000022000C16000022000C12000022000C1686"
data "00036001019B"
data "0003600241000022000C1221008C12000022000C16000022000C12000022000C160000"
data "22000C1221008C16000022000C16000022000C12000022000C16000022000C124C2E0E"
data "00038001017B"
data "000380024165304A060319852B862B922B7A304A0603198B2B8C2B922B61304A06031D"
data "912B922BFA2B8C1222008C12000022000C16000022000C128C16000022000C16000074"
data "0003A001015B"
data "0003A0024122000C1221008C16000022000C16000022000C12000022000C1600002200"
data "0C12653021004A06031DB62BB72BB92B4C2E4C2E8C1222008C12000022000C160000AC"
data "0003C001013B"
data "0003C0024122000C12000022000C16000022000C1221008C16000022000C1600002200"
data "0C12000022000C16000022000C127A3021004A06031DDC2BDD2BDE2B4C2E8C12000000"
data "0003E001011B"
data "0003E0024122000C16000022000C12000022000C16000022000C1221008C1600002200"
data "0C16000022000C12000022000C16000022000C124C2E49304A06031DFF2B002C9A2C88"
data "0004000101FA"
data "0004000241C3018C1222008C12000022000C16000022000C12000022000C1600002200"
data "0C1221008C16000022000C16000022000C1220008C1E1C2C1D2C202C2100C301C30AEF"
data "0004200101DA"
data "0004200241000022000C16000022000C1221008C12000022000C16000022000C120000"
data "22000C16000022000C1221008C16000022000C16000022000C1220008C1E402C412C64"
data "0004400101BA"
data "0004400241442C2100C30AC30A000022000C16000022000C1221008C12000022000C16"
data "000022000C12000022000C16000022000C1221008C16000022000C16000022000C12BC"
data "00046001019A"
data "000460024120008C1E642C652C682C04302100C307000022000C16000022000C122100"
data "8C12000022000C16000022000C12000022000C16000022000C1221008C16000022008B"
data "00048001017A"
data "00048002410C16000022000C1220008C1E882C892C8C2C08302100C307000022000C16"
data "000022000C1249302100C30743089C31CC2481314C2E44304A06031D9F2CA02CCC2C3A"
data "0004A001015A"
data "0004A002418C1222008C12000022000C16000022000C12000022000C16000022000C12"
data "21008C16000022000C16000022000C1220008C1EBB2CBC2CC12C31309C31CC24813116"
data "0004C001013A"
data "0004C00241C52C30309C31CC248131000022000C16000022000C124C2E61304A02031C"
data "D12CD22CD82C7B304A02031CD72CD82CE42C41304A02031CDD2CDE2CF02C5B304A0231"
data "0004E001011A"
data "0004E002410318E32CE42CF02CBD01BD0ABE01BE0A61304A02031CED2CEE2CF12CBE01"
data "F12CBD013D080319F52CF62C3F2E3E080319FA2CFB2C522D2330C60049304A02031C55"
data "0005000101F9"
data "0005000241022D032D392D59304A020318082D092D392D4A08B73E8931A3218131C600"
data "472DA001A00A00309031DE208131C600472DA00101309031DE208131C600472DA0013D"
data "0005200101D9"
data "0005200241A00A01309031DE208131C600472DA001A00A00309031DE208131A0010030"
data "9031DE208131A00100309031DE208131C600472D4A08413A0319272D043A0319102D94"
data "0005400101B9"
data "0005400241033A0319182D013A03191F2D472D2330460603194C2D4D2D4C2E46089C31"
data "CC2481314C2E69304A02031C572D582D772D79304A0203185D2D5E2D772D4A08973EC3"
data "000560010199"
data "00056002419531C02581314C2EA001003090317F2081314C2EA001013090317F208131"
data "4C2EA001A00A013090317F2081314C2E4A08643A0319642D023A03196A2D013A0319DB"
data "000580010179"
data "0005800241702DB82B00309D31542581314C2E01309D31542581314C2EA00100309031"
data "DE208131303A031D952D962D4C2E3030C0004C2E3C309C31CC2481310230CE004C2EB7"
data "0005A0010159"
data "0005A0024140089C31CC2481313130C0004C2E8E1122008E114C2E8E154C2E0E142300"
data "CD0121004A0894314D2481314C2E4D080319BA2DBB2D4C2E0E1022000E102300CD01DE"
data "0005C0010139"
data "0005C00241CD0A4C2E8E142300CE0121004A0894314D2481314C2E4D080319CF2DD02D"
data "4C2E8E1022008E102300CE01CE0A4C2ECE0114304E02031CDD2DDE2DD82D4C2ECD01D4"
data "0005E0010119"
data "0005E00241CD0A4C2E9D31AE2581319C31CC2481314C2E56309C31CC24813131309C31"
data "CC2481312E309C31CC24813131309C31CC24813138309C31CC2481310D309C31CC2418"
data "0006000101F8"
data "000600024181310A309C31CC2481314C2E61309C31CC24813173309C31CC2481316330"
data "9C31CC24813169309C31CC24813169309C31CC24813120309C31CC24813149309C31B9"
data "0006200101D8"
data "0006200241CC24813143309C31CC24813153309C31CC24813150309C31CC2481312030"
data "9C31CC24813176309C31CC24813131309C31CC2481314E309C31CC2481314C2E4A08D5"
data "0006400101B8"
data "0006400241DF3E031CB82B84001F3004020318B82B90310435003E820021004808443E"
data "86000230493D8700160001040319582E592E5F2E24303F02031C5E2E5F2EC02A0A304D"
data "000660010198"
data "0006600241A90001309131C02181312229911E692E6A2E702E9D31752581319C31CC24"
data "81313C302100A90028309131C021813121004808443E86000230493D87001600010422"
data "000680010178"
data "00068002410319832E842ED62E23009E1C882E892ED62E21004808423E86000230493D"
data "8700403F48078400413F493D85000008CA004808423E86000230493D870001308107B3"
data "0006A0010158"
data "0006A0024141310318810A4808423E86000230493D8700403FB800413FB9003908803A"
data "BA0082303A02031DB62E40303802031CB92EBA2EC42E21004808423E86000230493D9A"
data "0006C0010138"
data "0006C0024187000030C03FC13F21004808443E86000230493D8700FF3081074131FF30"
data "813D7F314A089C31A924813122292229803158287834033446340034413400344B34A5"
data "0006E0010118"
data "0006E00241003445340034203400345334003465340034723400346934003461340034"
data "6C340034203400344E340034753400346D3400346234003465340034723400343A34CF"
data "0007000101F7"
data "0007000241003420340034443400346F3400346E340034273400347434003420340034"
data "7334003468340034693400347034003420340034613400342034003470340034723403"
data "0007200101D7"
data "000720024100346F34003464340034753400346334003474340034203400346C340034"
data "693400346B3400346534003420340034743400346834003469340034733400342E342C"
data "0007400101B7"
data "0007400241003420340034503400344C34003445340034413400345334003445340034"
data "21340034303403345334003469340034673400346E340034613400346C34003420344A"
data "000760010197"
data "00076002410034313400343134003420340034533400346F3400346634003474340034"
data "77340034613400347234003465340034203400344C3400344C340034433400342E34E0"
data "000780010177"
data "0007800241003426340334433400344434003443340034203400344434003461340034"
data "743400346134003420340034493400346E3400347434003465340034723400346634A1"
data "0007A0010157"
data "0007A0024100346134003463340034653400341C340334433400344434003443340034"
data "20340034493400346E3400347434003465340034723400346634003461340034633438"
data "0007C0010137"
data "0007C002410034653400341A3403345534003453340034423400342034003443340034"
data "4434003443340034203400345434003465340034733400347434003404340334093450"
data "0007E0010117"
data "0007E00241043409340234463400340234013402348034323408340B34003402340234"
data "02340034023409340434003400340134023402340034033405342434003410340134E0"
data "0008000101F6"
data "000800024104342434023406340534243406340034013407340534813403340A340034"
data "0134093404340134003402340A3400340034043407340534823402344034003401344B"
data "0008200101D6"
data "000820024107340534023402344034003401341234013410340134EF34023401340834"
data "D83404340A34003400340134013402340034013480342034883420340034E13487340B"
data "0008400101B6"
data "00084002412108BD006C03031D462847285A286608670403194C284D285628FC01FC0A"
data "6B08FD0067088A0066080A0088319C31B8248831D3286D0803195E285F28D3283D086D"
data "000860010196"
data "0008600241B800B90165083902031D682864083802031C6B286C2871286508BB006408"
data "BA0074283D08BA00BB013A08BE006D08860001308700882823005F0884006008850003"
data "000880010176"
data "000880024120003E08B80012001E00B80B832889287B2820003E08ED073E08E402031C"
data "E50308303D02031C952896289C2864086504031D9B289C28D3283D083E020318A128E3"
data "0008A0010156"
data "0008A00241A228B4289C3198248831660867040319AA28AB285628FC016B08FD006708"
data "8A0066080A0088315628BC01660867040319BA28BB28C628FC01FC0A6B08FD006708B9"
data "0008C0010136"
data "0008C002418A0066080A0088312000BC00BC1FC928CA28CE289C3198248831D1289C31"
data "9D248831E601E7010800440886004508870044310108CE004408860045088700413147"
data "0008E0010116"
data "0008E0024120300106031DE528E6282229440886004508870021300106031DEF28F028"
data "22294E082300D700200044088600450887004631403FC600413FC70000304702073097"
data "0009000101F5"
data "000900024103194602031C052906290A290730C800C901132944088600450887004631"
data "403FC800413FC9004908F1004808F0002630F2001D30F300F401D8309D3164258831D8"
data "0009200101D5"
data "00092002410030A2294408860045088700413121300106031D2C292D296F2944088600"
data "45088700A1300106031D362937296F29D830F0004E08803102208831CC00CC1F4129D6"
data "0009400101B5"
data "000940024142294429FF30A22944088600450887004631403FC600413FC70000304702"
data "073003194602031C552956295A290730CA00CB01632944088600450887004631403F51"
data "000960010195"
data "0009600241CA00413FCB004B08C0004A08BF00C101C201C301D8309D31DB2588312029"
data "4408860045088700413123300106031D79297A294229440886004508870021300106BA"
data "000980010175"
data "0009800241031D83298429422944088600450887004231403FF000413FF1004E089E31"
data "CF2688312000CD00CD1F9629972998294229BF01C001C101C201C30100309D31DB2538"
data "0009A0010155"
data "0009A00241883120290800A300A2018C1223080139A000A00EA00D22000C0821002006"
data "DF39200622008C00000022000C16000022000C128C12000022000C16000022000C12B7"
data "0009C0010135"
data "0009C0024121008C16000022000C16000022000C1220008C1ECC29CD29D0292100A201"
data "A20A000022000C16000022000C1221008C1223360139A000A00EA00D22000C08210067"
data "0009E0010115"
data "0009E002412006DF39200622008C00000022000C16000022000C128C12000022000C16"
data "000022000C1221008C16000022000C16000022000C1220008C1EFE29FF29022A21006F"
data "000A000101F4"
data "000A000241A20AA20A000022000C16000022000C1221008C122308A000A036A0362008"
data "0139A100A10EA10D22000C0821002106DF39210622008C00000022000C160000220070"
data "000A200101D4"
data "000A2002410C128C12000022000C16000022000C1221008C16000022000C1600002200"
data "0C1220008C1E342A352A382A04302100A207000022000C16000022000C1221008C12E2"
data "000A400101B4"
data "000A4002412308A000A036A036A03620080139A100A10EA10D22000C0821002106DF39"
data "210622008C00000022000C16000022000C128C12000022000C16000022000C12210094"
data "000A60010194"
data "000A6002418C16000022000C16000022000C1220008C1E6B2A6C2A6F2A08302100A207"
data "000022000C16000022000C1249302100A20722080800530803197E2A7F2AE62A21307B"
data "000A80010174"
data "000A800241FB00AA30FA007B08F1007A08F0009031A9208A3121008E1122008E11E62A"
data "9C30F0003F3090313E208A31682B4E30F0001F3090313E208A31682B2730F0000F3060"
data "000AA0010154"
data "000AA0024190313E208A31682B1330F000873090313E208A31682B0930F000C3309031"
data "3E208A31682B0430F000E13090313E208A31682B0230F000713090313E208A31682BF4"
data "000AC0010134"
data "000AC00241F001F00A373090313E208A31682BF001D03090313E208A31682BF0019B30"
data "90313E208A31682BF001683090313E208A31682BF001333090313E208A31682BF00105"
data "000AE0010114"
data "000AE00241F00A373090313E208A31682B7508860001308700403FF600413FF700423F"
data "F800433FF9007908003A03195D2BDF2A7708013A0319142B033A0319192B063A0319F4"
data "000B000101F3"
data "000B0002411E2B0D3A0319232B1B3A0319282B373A03192D2B6E3A0319322BDD3A0319"
data "372B773A03193C2BDF2A76082C3A03198F2ADF2A7608583A0319962ADF2A7608B03AFD"
data "000B200101D3"
data "000B20024103199D2ADF2A7608603A0319A42ADF2A7608C03A0319AB2ADF2A7608803A"
data "0319B22ADF2A7608003A0319B92ADF2A7608003A0319C02ADF2A7608003A0319C72AA4"
data "000B400101B3"
data "000B400241DF2A77082C3A0319492BEE3A03194E2BDF2A7608003A0319CD2ADF2A7608"
data "003A0319D32ADF2A7708843A0319582BDF2A7608003A0319D92ADF2A7808003A0319E5"
data "000B60010193"
data "000B600241F72A013A0319412B023A0319532BDF2A530803196C2B6D2B702BD3012100"
data "8E15003008003D00101C762B772B7F2B9C318A248B31933131238B313D001010901E12"
data "000B80010173"
data "000B800241822B832BAD2B2000E101E10AE20198302000DB000E30DC0061085B07DD00"
data "62085C3DDE005D08DF005E08E0005F088600600887000110E10A0319E20A6208803A3B"
data "000BA0010153"
data "000BA00241DB0080305B02031DA72B03306102031CAA2BAB2B872B3D009012901DB02B"
data "B12B5D2C921DB42BB52B5D2C0F0C2000DB00DB0C5B0C0F39003A031DBF2BC02BEB2B72"
data "000BC0010133"
data "000BC002413D000F19C42BC52BEB2B2000200C890C0F39E3000D306306031DCF2BD02B"
data "D42B9231D9228B31E72B09306306031DD92BDA2BDB2BE72B6303031DDF2BE02BE42BB9"
data "000BE0010113"
data "000BE00241883140208B31E72B9C3198248B319C31A3248B315B2C3D000F0C2000DB00"
data "DB0C5B0C0F39003A031DF62BF72B002C3D000F1DFB2BFC2B002C953138258B315B2CD5"
data "000C000101F2"
data "000C0002413D000F0C2000DB00DB0C5B0C0F39003A03190B2C0C2C5B2C3D000F0C2000"
data "DB00DB0C5B0C0F39DC0003305C020318192C1A2C5B2C3D000F1D1E2C1F2C3D2C07305B"
data "000C200101D2"
data "000C200241F0000F0C2000DB00DB0C5B0C0F3991314A218B315E3E860002308700811C"
data "312C322C5B2C3D000F0C2000DB00DB0C5B0C0F399E31B1268B315B2C0730F0000F0C3E"
data "000C400101B2"
data "000C4002412000DB00DB0C5B0C0F3991314A218B315E3E860002308700011C4F2C502C"
data "5B2C3D000F0C2000DB00DB0C5B0C0F399D3186258B315B2C3D009011101F602C612CB6"
data "000C60010192"
data "000C600241652C9C3189248B3110132000121D692C6A2C6B2C12110800C90123006008"
data "2000D70023005F082000D6005608860057088700413106300106031D7F2C802C1F2D23"
data "000C80010172"
data "000C800241560886005708870080300106031D892C8A2C1F2D56088600570887004231"
data "403FBF00413FC0004008D400560886005708870042310108D0005403031DA02CA12CDC"
data "000CA0010152"
data "000CA00241B92C2730F7008830F80027308400883085000008F900FA01560886005708"
data "87004631403FFB00413FFC009431B9248C31FD2E02305406031DBE2CBF2CF12C500863"
data "000CC0010132"
data "000CC002410319C32CC42CC82C9C3198248C31FD2E5035E43E860001308700403FCB00"
data "413FCC004C08F8004B08F7004C08C0004B08BF0002303F07840040080318400A85002C"
data "000CE0010112"
data "000CE00241003FF900013FFA0056088600570887004631403FFB00413FFC009431B924"
data "8C31FD2E03305406031DF62CF72CF82CC42C5708F1005608F0004F30F2009C318E240A"
data "000D000101F1"
data "000D0002418C317108CE007008CD00CE1F082D092D0A2DC42C4F08F7000030F8004E08"
data "FA004D08F90056088600570887004631403FFB00413FFC009431B9248C31FD2E5608B5"
data "000D200101D1"
data "000D200241860057088700413105300106031D292D2A2D3A2D2300D001D00A20005608"
data "860057088700423101082300CF009C319D248C31FD2E56088600570887004131093031"
data "000D400101B1"
data "000D4002410106031D442D452D552D560886005708870042310108C700963172268C31"
data "9C319D248C314708EF00FD2E5608860057088700413108300106031D5F2D602D742DB2"
data "000D60010191"
data "000D6002416F30F7000030F800F901F90AFA0156088600570887004631403FFB00413F"
data "FC009431B9248C31FD2E560886005708870041310108031D7D2D7E2DFB2D5608860013"
data "000D80010171"
data "000D8002415708870001081F39003A031D882D892DA42D9C318B248C317108C2007008"
data "C1004130F7000030F8000230F900FA0156088600570887004631403FFB00413FFC00B9"
data "000DA0010151"
data "000DA002419431B9248C31FD2E560886005708870001081F39023A031DAE2DAF2DC42C"
data "560886005708870044310108D2000F30D205033052020318BD2DBE2DC42C0730F0009A"
data "000DC0010131"
data "000DC00241520891314A218C315E3E86000230870001082000D1005608860057088700"
data "4431811BD32DD42DD92D51080139C500C601DD2D51080239C500C60145084604031DF5"
data "000DE0010111"
data "000DE00241E22DE42D0130E52D0030C300C4014330F7000030F8000230F900FA015608"
data "8600570887004631403FFB00413FFC009431B9248C31FD2E5608860057088700413100"
data "000E000101F0"
data "000E0002410B300106031D052E062E072E362D560886005708870041310A300106031D"
data "112E122E272EC8014830F7000030F800F901F90AFA0156088600570887004631403FC5"
data "000E200101D0"
data "000E200241FB00413FFC009431B9248C31FD2E5608860057088700413101030319302E"
data "312E3C2E5608860057088700413103300106031D3B2E3C2EFB2ECA01CA0A56088600F6"
data "000E400101B0"
data "000E4002415708870001081F39023A031D482E492EF52E560886005708870042311600"
data "0104031D532E542EF52E560886005708870044310108D5000F30D505560886005708A5"
data "000E60010190"
data "000E600241870044310108D3008030D3050330550203186B2E6C2EF52E560886005708"
data "8700413103300106031D762E772E862E530803197B2E7C2E812E55089E3177268C3162"
data "000E80010170"
data "000E800241F32E55089E3194268C31F32E530803198A2E8B2EBF2E5508090709070907"
data "253E860087010730F000550891314A218C315D3E84000230850000088100200055082D"
data "000EA0010150"
data "000EA00241090709070907243E8600870181010730F000550891314A218C315E3E8600"
data "0230870081110730F0002000550891314A218C315E3E8600023087008110F32E55089A"
data "000EC0010130"
data "000EC00241090709070907213E860087010730F000550891314A218C315C3E84000230"
data "85000008810020005508090709070907203E86008701883081000730F00055089131EE"
data "000EE0010110"
data "000EE002414A218C315E3E86000230870001150730F0002000550891314A218C315E3E"
data "86000230870001102000CA014A08031DF92EFA2EC42C362DC901C9032000490808002E"
data "000F000101EF"
data "000F000241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FEE"
data "000F200101CF"
data "000F200241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FCE"
data "000F400101AF"
data "000F400241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FAE"
data "000F6001018F"
data "000F600241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F8E"
data "000F8001016F"
data "000F800241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F6E"
data "000FA001014F"
data "000FA00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F4E"
data "000FC001012F"
data "000FC00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F2E"
data "000FE001010F"
data "000FE00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F0E"
data "0010000101EE"
data "00100002418531E92D8331B82B8331B82B8331B82B8331B82B8331B82B8331B82B8331"
data "B82B8331B82B8331B82B85318C2D8331B82B8531E22D8331B82B8331B82B8531822D34"
data "0010200101CE"
data "00102002418531872D8531A72D8531AB2D8531AD2D8531B62D8531C22D8531CB2D8531"
data "D72D8531DF2D8331B82B8331B82B8331B82B8531A02D8531992D8631062EF100210052"
data "0010400101AE"
data "00104002418E160E12243023009E0090309D0008309F001D161E129D1771089B009C01"
data "70089C009D1C5428552858289D1319089D171908080000309C31FC249031003A031D6C"
data "00106001018E"
data "0010600241622863287E282300E3196728692801306A280030F6002000A40176080319"
data "7128722877287408A500C830A4007B287408A5008830A40008302300E3060800A1006F"
data "00108001016E"
data "00108002418C1221082200031D8C1603198C12000022000C16000022000C1221002008"
data "2200031D8C1603198C12000022000C16000022000C1221008C16000022000C160000D2"
data "0010A001014E"
data "0010A0024122000C12000022000C16000022000C1208007008443E86000230713D8700"
data "0030C03FC13F7008403E86000230713D87000030C03FC13F7008423E86000230713DBB"
data "0010C001012E"
data "0010C0024187000030C03FC13FF301F4017308700786007408713D87008101F30A0319"
data "F40A7408803AF20082307202031DD92840307302031CDC28DD28C6280800A100303019"
data "0010E001010E"
data "0010E00241A2008C1221082200031D8C1603198C12000022000C16000022000C122100"
data "20082200031D8C1603198C12000022000C16000022000C1221008C16000022000C16D0"
data "0011000101ED"
data "0011000241000022000C1220008C1E072908290B2931302100A200000022000C160000"
data "22000C122100220808002008443E86000230213D87000030C03FC13F2008403E860070"
data "0011200101CD"
data "00112002410230213D87000030C03FC13F2008423E86000230213D87000030C03FC13F"
data "A301A40121002308200786002408213D87008101A30A0319A40A2408803AA20082304C"
data "0011400101AD"
data "00114002412202031D452940302302031C4829492931290800F100F201711C4F295029"
data "52297008F207F035F11C5629572959297008F207F035711D5D295E2960297008F20795"
data "00116001018D"
data "0011600241F035F11D6429652967297008F207F035711E6B296C296E297008F207F035"
data "F11E7229732975297008F207F035711F79297A297C297008F207F035F11F8029812906"
data "00118001016D"
data "001180024183297008F20772080800A200A101221C8A298B298D292008A107A035A21C"
data "9129922994292008A107A035221D982999299B292008A107A035A21D9F29A029A2296E"
data "0011A001014D"
data "0011A002412008A107A035221EA629A729A9292008A107A035A21EAD29AE29B0292008"
data "A107A035221FB429B529B7292008A107A035A21FBB29BC29BE292008A1072108080033"
data "0011C001012D"
data "0011C00241AB002B084E020318C629C729CD2929084F02031CCC29CD29FE294F080319"
data "D129D229FB2902309C31EF249131003A031DDA29DB29D22902309D3144259131230809"
data "0011E001010D"
data "0011E00241860024088700F029203084000230850021004F08AA0012001E00AA0BEB29"
data "F129E42921004F08A400A50102309231862291312100CF01CE0120009A0108002708DA"
data "0012000101EC"
data "0012000241B1002608B00020303102003003193002031C0B2A0C2A112A3108A7003008"
data "A600412A3108AE003008AF002F088039A800A9012E08AA00AB01AA35AB0D28082A0799"
data "0012200101CC"
data "0012200241AC0029082B3DAD002C082D04031D292A2B2A01302C2A0030A000A1015030"
data "A200A3019E310D2691312108A7002008A6002F087F39A6070318A70AE030A6071F30D7"
data "0012400101AC"
data "0012400241A73D080077082000BB007608BA0020303B02003003193A02031C4F2A502A"
data "552A3B08F7003A08F600852A3B08B8003A08B90039088039F800F9013808FA00FB010E"
data "00126001018C"
data "0012600241FA35FB0D78087A07FC0079087B3DFD007C087D04031D6D2A6F2A0130702A"
data "0030F000F1015030F200F3019D31F42592317108F7007008F60039087F39F6070318B0"
data "00128001016C"
data "0012800241F70AE030F6071F30F73D0800A70020006F0803198C2A8D2AD82A21002708"
data "9D310A259231003A031D962A972AD82A2708090709070907243EA8000730A00027086D"
data "0012A001014C"
data "0012A002419131852192315E3E8600023087008119AA2AAC2A0130AD2A0030A6002808"
data "86008701810126080319B62AB72AC22A280A8600870124088100280886008701C83009"
data "0012C001012C"
data "0012C002418100CC2A280A8600870124088100280886008701883081000730A0002708"
data "9131852192315E3E860002308700083081060800230060082000DA0023005F0820000E"
data "0012E001010C"
data "0012E00241D900590886005A0887000030811B0130EC009C3194249231A41FEF2AF02A"
data "F32A0830A500A401640865040319F82AF92A0A2B660867040319FE2AFF2A072BFC017C"
data "0013000101EB"
data "00130002416B08FD0067088A0066080A0093319C31B8249231590886005A088700010E"
data "890C0339003A031D152B162B1E2B8C316C249231D800D81F1D2B1E2B2E2B5A08D000CA"
data "0013200101CB"
data "00132002415908CF009C31B02492312000D800D81F2A2B2B2B2E2B9C31982492313D00"
data "0E12080011109110920197018E151116111590119011901190119001921592161214EB"
data "0013400101AB"
data "001340024112179830F0000E30F100F201F3011030F400F5019E31262693313D001816"
data "98111815981418102000BF01BF0A3F08983EBD00BE010E30BE3D3D08C0003E08C100CE"
data "00136001018B"
data "0013600241400886004108870001164008860041088700811540088600410887000115"
data "4008860041088700811440088600410887000110BF0A03303F02031C7F2B802B562B99"
data "00138001016B"
data "00138002413D0096012300D0012000EF019631722693319C31B8249331210012150800"
data "2100A4000730A00024089131852193315E3E86000230870001199E2BA02B0130A12BF8"
data "0013A001014B"
data "0013A002410030A30023080319A62BA72BC42B2408090709070907213E860087010730"
data "A00024089131852193315C3E840002308500000881002408090709070907203E8600C8"
data "0013C001012B"
data "0013C002418701C8308100E02B2408090709070907213E860087010730A00024089131"
data "852193315C3E840002308500000881002408090709070907203E860087018830810087"
data "0013E001010B"
data "0013E002410730A00024089131852193315E3E8600023087000430810608003D001110"
data "9110920197018E15111611159011901190119011900192159216121412179830210047"
data "0014000101EA"
data "0014000241A0000E30A100A201A3011030A400A5019E315C2693313D00181698111815"
data "981418102100B501B50A3508983EB300B4010E30B43D3308B6003408B7003608860047"
data "0014200101CA"
data "0014200241370887000116360886003708870081153608860037088700011536088600"
data "37088700811436088600370887000110B50A03303502031C3D2C3E2C142C3D00960103"
data "0014400101AA"
data "00144002412300D0012000EF019731342793319C31C2249331210012150800A7004D08"
data "0319522C532C5E2C23004E08031D582C592C5E2C4D0803195D2C5E2C702C21004D0856"
data "00146001018A"
data "0014600241031D632C642C6A2C343027060319692C6A2C702C58302706031D6F2C702C"
data "B82C2300D4015830210027060319782C792C7F2C2300D301D30A22008C120C12000080"
data "00148001016A"
data "0014800241000000000000000000000000000000000000000000000000000000000000"
data "000000000000000021008E152000EA0121302100A600AA30A5002608A1002508A00027"
data "0014A001014A"
data "0014A002419131142194312100CE0105304E02031CAA2CAB2CA52C24008C120C122100"
data "8C160C168E140E142300CE01CD012100CD01080000307A02083003197902031CC12C74"
data "0014C001012A"
data "0014C00241C22CC62C0830BA00BB01CA2C7A08BB007908BA003A08BE003E08B800B901"
data "7C083902031DD52C7B083802031CD82CD92CDE2C7C08BD007B08BC00E12C3E08BC00D7"
data "0014E001010A"
data "0014E00241BD013C08BE007C087A02031DE92C7B087902031CEC2CEE2C0130EF2C0030"
data "2300D60020003E080319F62CF72C0A2D23006108860062088700092D77088400780856"
data "0015000101E9"
data "0015000241850020003E08B80012001E00B80B042D0A2DFD2C78082300CC007708CB00"
data "20003E082300CB070318CC0A7A087C02031D1B2D79087B02031C1E2D1F2D252D7A088C"
data "0015200101C9"
data "00152002412000E5007908E4002A2D7C082000E5007B08E4003E08E402031CE5032300"
data "E31520003E08F400F50190315A20943108002300500803193D2D3E2D432D4F083D00C1"
data "0015400101A9"
data "001540024196002300D0012000640865040319492D4A2D982D00306502083003196402"
data "031C522D532D572D0830B900BA015B2D6508BA006408B9003908BB002300610886009A"
data "001560010189"
data "001560024162088700702D23004B0884004C08850020003B08B80012001E00B80B6B2D"
data "712D632D20003B08E402031CE5033B082300CB070318CC0A200064086504031D812DD7"
data "001580010169"
data "0015800241822D902D08303B06031D872D882D902D2300560803198D2D8E2D902DD201"
data "D20A20003B08F400F50190315A209531BF2D2300520803199D2D9E2DA92DF401F50156"
data "0015A0010149"
data "0015A0024190315A2095312300D2019C31B8249531BF2D20006C08031DAE2DAF2DBF2D"
data "660867040319B42DB52DA52DFC01FC0A6B08FD0067088A0066080A009531A52D080051"
data "0015C0010129"
data "0015C00241A2008C1222080139A000A00EA00D22000C0821002006DF39200622008C00"
data "000022000C16000022000C128C12000022000C16000022000C1221008C160000220055"
data "0015E0010109"
data "0015E002410C16000022000C12000022000C16000022000C1221008C1222360139A000"
data "A00EA00D22000C0821002006DF39200622008C00000022000C16000022000C128C120B"
data "0016000101E8"
data "0016000241000022000C16000022000C1221008C16000022000C16000022000C120000"
data "22000C16000022000C1221008C122208A000A036A03620080139A100A10EA10D2200A1"
data "0016200101C8"
data "00162002410C0821002106DF39210622008C00000022000C16000022000C128C120000"
data "22000C16000022000C1221008C16000022000C16000022000C12000022000C1600000D"
data "0016400101A8"
data "001640024122000C1221008C122208A000A036A036A03620080139A100A10EA10D2200"
data "0C0821002106DF39210622008C00000022000C16000022000C128C12000022000C16EB"
data "001660010188"
data "0016600241000022000C1221008C16000022000C16000022000C12000022000C160000"
data "22000C1208003D000E172300E3012000BC010730F0003C0891314A2196315E3E86006D"
data "001680010168"
data "001680024102308700043081002000BC0A03303C02031C8B2E8C2E782E2030F0000030"
data "F100F201F3011830F400F5019E312626963123006008F7005F08F60092314222963101"
data "0016A0010148"
data "0016A002417708A3007608A2000830A1008030A00023006208F7006108F60092314222"
data "96317708A7007608A6000830A500A401BC01BC0A0730F0003C0891314A219631583E87"
data "0016C0010128"
data "0016C00241860002308700403FF600413FF7009231422296313C08090709070907223E"
data "860087017608C03F7708C13F3C08090709070907213E860087010730F0003C089131E2"
data "0016E0010108"
data "0016E002414A2196315C3E8400023085000008810020003C08090709070907203E8600"
data "8701883081000730F0003C0891314A2196315A3E860002308700403FF600413FF700DC"
data "0017000101E7"
data "00170002419231422296313C08090709070907263E860087017608C03F7708C13F3C08"
data "090709070907253E860087010730F0003C0891314A2196315D3E8400023085000008B4"
data "0017200101C7"
data "0017200241810020003C08090709070907243E860087018101BC0A03303C02031C302F"
data "312FB92E3D000E1308003D000E172300E3012100B2010730A00032089131852197319F"
data "0017400101A7"
data "00174002415E3E86000230870004308100B20A03303202031C4C2F4D2F3A2F2030A000"
data "0030A100A201A3011830A400A5019E315C269731230060082100A70023005F08210083"
data "001760010187"
data "0017600241A6009131FF21973127082000A300210026082000A2000830A1008030A000"
data "230062082100A700230061082100A6009131FF21973127082000A70021002608200013"
data "001780010167"
data "0017800241A6000830A500A4012100B201B20A0730A0003208913185219731583E8600"
data "02308700403FA600413FA7009131FF2197313208090709070907223E8600870126085C"
data "0017A0010147"
data "0017A00241C03F2708C13F3208090709070907213E860087010730A000320891318521"
data "97315C3E840002308500000881003208090709070907203E860087018830810007301C"
data "0017C0010127"
data "0017C00241A00032089131852197315A3E860002308700403FA600413FA7009131FF21"
data "97313208090709070907263E860087012608C03F2708C13F3208090709070907253E0A"
data "0017E0010107"
data "0017E00241860087010730A00032089131852197315D3E840002308500000881003208"
data "090709070907243E860087018101B20A03303202031CFC2FFD2F872F3D000E13080007"
data "0018000101E6"
data "0018000241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FE5"
data "0018200101C6"
data "0018200241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FC5"
data "0018400101A6"
data "0018400241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FA5"
data "001860010186"
data "0018600241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F85"
data "001880010166"
data "0018800241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F65"
data "0018A0010146"
data "0018A00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F45"
data "0018C0010126"
data "0018C00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F25"
data "0018E0010106"
data "0018E00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F05"
data "0019000101E5"
data "0019000241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FE4"
data "0019200101C5"
data "0019200241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FC4"
data "0019400101A5"
data "0019400241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FA4"
data "001960010185"
data "0019600241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F84"
data "001980010165"
data "0019800241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F64"
data "0019A0010145"
data "0019A00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F44"
data "0019C0010125"
data "0019C00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F24"
data "0019E0010105"
data "0019E00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F04"
data "001A000101E4"
data "001A000241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FE3"
data "001A200101C4"
data "001A200241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FC3"
data "001A400101A4"
data "001A400241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FA3"
data "001A60010184"
data "001A600241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F83"
data "001A80010164"
data "001A800241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F63"
data "001AA0010144"
data "001AA00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F43"
data "001AC0010124"
data "001AC00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F23"
data "001AE0010104"
data "001AE00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F03"
data "001B000101E3"
data "001B000241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FE2"
data "001B200101C3"
data "001B200241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FC2"
data "001B400101A3"
data "001B400241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FA2"
data "001B60010183"
data "001B600241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F82"
data "001B80010163"
data "001B800241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F62"
data "001BA0010143"
data "001BA00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F42"
data "001BC0010123"
data "001BC00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F22"
data "001BE0010103"
data "001BE00241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F02"
data "001C000101E2"
data "001C000241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FE1"
data "001C200101C2"
data "001C200241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FC1"
data "001C400101A2"
data "001C400241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FA1"
data "001C60010182"
data "001C600241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
data "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F81"
data "001C80010162"
data "001C800241FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F08000800F001F1010800F001"
data "F101080020006F0808000830A500A40108000830A5008430A40008002000A401A5013C"
data "001CA0010142"
data "001CA00241C830A400080008302000A1008030A0000800A000200823009A000130D500"
data "08005008C5004F08C4008831D4209C3108002300CB01CC012000ED01E401E501E60143"
data "001CC0010122"
data "001CC00241E70108002300CB01CC012000ED01E401E501E601E70108002100A0004F08"
data "203E86000230870020088100CF0A0800583020009C049C101C147D309B002100911414"
data "001CE0010102"
data "001CE0024120001C1508006400800101310130FE020030FF3B7F087E04031DE42C0034"
data "2100A0002008090709070907243E86008701010D010D01390800F3000730F0007308CD"
data "001D000101E1"
data "001D00024191314A219C315E3E860002308700010802390800A3000730A00023089131"
data "85219D315E3E860002308700010802390800A0002008090709070907203E8600870119"
data "001D200101C1"
data "001D2002410310811F03140030093D08007C08031D2A2D2B2D2D2DFF30342DD830F500"
data "230057088A317A229D3108002100A3000730A0002308913185219D315E3E86000230FF"
data "001D400101A1"
data "001D4002418700010801390800A6000730A0002608913185219D315A3E860002308700"
data "403FA300413FA40008002100A0008C1220082200031D8C1603198C12000022000C161F"
data "001D60010181"
data "001D600241000022000C120800F5009C31B8249D317308E7007208E6007508ED007108"
data "E5007008E4007408EB00080023009D1C792D7A2D7D2D1D1219081D1619082100A000FF"
data "001D80010161"
data "001D80024101302300D500210020080800F0007008090709070907213E860087018101"
data "7008090709070907203E86008701843081000800003400340034003400340034003462"
data "001DA0010141"
data "001DA00241903420349134203401340A3400349B342034DB3420344034403400343030"
data "2100A0008C16000022000C16000022000C12000020008C1EBD2DBE2DC12D3130210030"
data "001DC0010121"
data "001DC00241A0002100200808003C302100990427001B169B1723008C018E01FF302100"
data "8C00FF308E000E11951324008C158C120C120B178B170800FD004208E7004108E60072"
data "001DE0010101"
data "001DE002414308EB007D08F700FF39031D0130F8004008FA003F08F9004008FC003F08"
data "FB009431B9249D310800F401F501701CF92DFA2DFE2D7208F4077308F53DF235F30DD5"
data "001E000101E0"
data "001E000241F136F00C70087104031D072E082EF62D7508F1007408F0000800A401A501"
data "201C122E132E172E2208A4072308A53DA235A30DA136A00C20082104031D202E212EBC"
data "001E200101C0"
data "001E2002410F2E2508A1002408A00008007108F7007008F600342E7608860077088700"
data "72088100F60A0319F70A0130F4020030F53B740A031D3F2E750A031D3F2E402E2B2ED9"
data "001E400101A0"
data "001E4002410800A4000730A0002408913185219E31583E860002308700230884008501"
data "403F803F413F813F2408090709070907213E86008701010808002108A7002008A60079"
data "001E60010180"
data "001E6002416A2E260886002708870022088100A60A0319A70A0130A4020030A53B240A"
data "031D752E250A031D752E762E612E0800F400740803197C2E7D2E932E03307402031CA6"
data "001E80010160"
data "001E800241822E832E842E932E0730F000740891314A219E315E3E8600023087008114"
data "74089E31B1269E310800F30073080319992E9A2EB02E03307302031C9F2EA02EA12E1B"
data "001EA0010140"
data "001EA00241B02E0730F000730891314A219E315E3E860002308700011473089D318625"
data "9E310800F3007308090709070907253E860087010730F000730891314A219E315D3E80"
data "001EC0010120"
data "001EC00241840002308500000881007308090709070907243E86008701843081000800"
data "6A08031DD32ED42EEF2E23005108031DD92EDA2EEE2E21008E1122008E1100000000C9"
data "001EE0010100"
data "001EE002410000000000000000000000000000000021008E152300D101D10AEF2ED101"
data "00300800FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F803100005828EB"
data "finished"
